//Listing 16.8. Wykorzystanie tej samej funkcji skadowej do ustawiania oraz pobierania danej obiektu klasy Array
#include <iostream>
using namespace std;

class Array {
public:
  int size; // liczba dozwolonych elementw
  int *ptr; // wskanik na tablic elementw
  void set(const int* a, int n); // przydziel (zainicjalizuj) pami na stercie
public:
  Array (const int* a, int n); // konstruktor oglny
  Array (const Array &s); // konstruktor kopiujcy
  ~Array(); // zwolnij pami na stercie
  Array& operator = (const Array& a); // skopiuj tablic do innej tablicy
  int getSize() const;
  int& getInt(int i) const; // pobierz (ustaw) warto na i-tej pozycji
} ;

void Array::set(const int* a, int n)
{ size = n; // oblicz rozmiar tablicy
  ptr = new int[size]; // zadaj pamici na stercie
  if (ptr == 0) { cout << "Brak pamici \n"; exit(0); }
  for (int i=0; i < size; i++)
       ptr[i] = a[i]; } // skopiuj dane klienta na stert

Array::Array(const int* a, int n) // konstruktor oglny
{ set(a,n); }

Array::Array (const Array &a) // konstruktor kopiujcy
{ set(a.ptr,a.size); }

Array::~Array() // destruktor
{ delete [ ] ptr; }

Array& Array::operator = (const Array& a)
{ if (this == &a) return *this; // brak operacji jeli przypisanie do tego samego obiektu
  delete [ ] ptr; // zwolnij istniejc pami
  set(a.ptr,a.size); // przydziel (ustaw) nowy obszar pamici
  return *this; } // w celu obsugi przypisywania w acuchu

int Array::getSize() const // pobierz rozmiar tablicy
{ return size; }

int& Array::getInt(int i) const // obiekt nie jest zmieniany
{ if (i < 0 || i >= size) // sprawd czy indeks jest poprawny
    return ptr[size-1]; // brak operacji jeli indeks przekracza granice
  return ptr[i]; } // indeks poprawny: ustaw odwoanie

int main()
{
  int arr[] = { 1,3,5,7,11,13,17,19 } ; // dane do przetworzenia
  Array a(arr, 8); // utwrz obiekt
  int size = a.getSize(); // pobierz rozmiar tablicy
  for (int i=0; i < size; i++) // przetwrz kady element
  { cout << " " << a.getInt(i); } // wywietl kolejny element
  cout << endl << endl;
  for (int j=0; j < size; j++) // ponownie przeszukaj tablic
  { int x = a.getInt(j); // pobierz kolejny element
    a.getInt(j) = 2*x; } // uaktualnij warto
  for (int k = 0; k < size; k++)
  { cout << " " << a.getInt(k); } // wywietl uaktualnion warto
  cout << endl;
  return 0;
}
